/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.benefit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectConfig;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.solonion.common.benefit.BenefitAttribute;
import team.creative.solonion.common.benefit.BenefitMobEffect;
import team.creative.solonion.common.benefit.BenefitType;

public abstract class Benefit<T> {
    public final RegistryObjectConfig<T> property;
    public double value;

    public Benefit(RegistryObjectConfig<T> property, double value) {
        this.property = property;
        this.value = value;
    }

    public Benefit(Registry<T> registry, CompoundTag nbt) {
        this.property = new RegistryObjectConfig(registry, ResourceLocation.tryParse((String)nbt.getString("key")));
        this.value = nbt.getDouble("val");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Benefit) {
            Benefit benefit = (Benefit)obj;
            return this.property.equals(benefit.property) && this.value == benefit.value;
        }
        return false;
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("type", BenefitType.getId(this));
        nbt.putString("key", this.property.location.toString());
        nbt.putDouble("val", this.value);
        return nbt;
    }

    static {
        ConfigTypeConveration.registerTypeCreator(Benefit.class, () -> new BenefitAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, 2.0));
        ConfigTypeConveration.registerType(Benefit.class, (ConfigTypeConveration)new ConfigTypeConveration<Benefit>(){

            public Benefit readElement(HolderLookup.Provider provider, Benefit defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("attribute")) {
                        return new BenefitAttribute(ResourceLocation.parse((String)object.get("attribute").getAsString()), object.get("value").getAsDouble());
                    }
                    return new BenefitMobEffect(ResourceLocation.parse((String)object.get("effect").getAsString()), object.get("value").getAsDouble());
                }
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    try {
                        return BenefitType.load(TagParser.parseTag((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                return defaultValue;
            }

            public JsonElement writeElement(HolderLookup.Provider provider, Benefit value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
                return new JsonPrimitive(value.save().toString());
            }

            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(final GuiParent parent, final IGuiConfigParent configParent, ConfigKey key, Side side) {
                parent.flow = GuiFlow.STACK_Y;
                parent.add((GuiControl)new GuiStateButton<BenefitType>(this, "state", 0, BenefitType.typeMap()){

                    public void raiseEvent(GuiEvent event) {
                        GuiComboBox box = (GuiComboBox)parent.get("elements");
                        Registry registry = ((BenefitType)this.selected()).registry();
                        GuiParent subConfig = (GuiParent)parent.get("subConfig");
                        if (subConfig == null) {
                            return;
                        }
                        subConfig.clear();
                        ((BenefitType)this.selected()).createControls(subConfig, configParent);
                        box.set((IComponentMap)new TextMapBuilder().addComponent((Iterable)registry.keySet(), value -> {
                            if (value.getNamespace().equals("minecraft")) {
                                return Component.literal((String)value.getPath());
                            }
                            return Component.literal((String)value.toString());
                        }));
                        super.raiseEvent(event);
                        this.reflow();
                    }
                });
                parent.add((GuiControl)new GuiComboBox("elements", (IComponentMap)new TextMapBuilder()).setSearchbar(true));
                parent.add((GuiControl)new GuiTextfield("value").setFloatOnly().setDim(20, 6));
                parent.add((GuiControl)new GuiParent("subConfig"));
            }

            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(Benefit value, Benefit defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiStateButton state = (GuiStateButton)parent.get("state");
                state.select((Object)BenefitType.getType(value));
                state.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)state));
                GuiComboBox box = (GuiComboBox)parent.get("elements");
                box.select((Object)value.property.location);
                GuiTextfield text = (GuiTextfield)parent.get("value");
                text.setText("" + value.value);
                GuiParent subConfig = (GuiParent)parent.get("subConfig");
                ((BenefitType)state.selected()).loadValue(value, subConfig, configParent);
            }

            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected Benefit saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiStateButton state = (GuiStateButton)parent.get("state");
                GuiComboBox box = (GuiComboBox)parent.get("elements");
                GuiTextfield text = (GuiTextfield)parent.get("value");
                return ((BenefitType)state.selected()).saveValue((ResourceLocation)box.selected(), text.parseDouble(), (GuiParent)parent.get("subConfig"), configParent);
            }

            public Benefit set(ConfigKey key, Benefit value) {
                return value;
            }
        });
    }
}

